% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed-methods.R
\name{summary.beezdemand_nlme}
\alias{summary.beezdemand_nlme}
\title{Summary method for beezdemand_nlme}
\usage{
\method{summary}{beezdemand_nlme}(object, report_space = c("natural", "log10"), ...)
}
\arguments{
\item{object}{A beezdemand_nlme object}

\item{report_space}{Character. Reporting space for core parameters. One of
\code{"natural"} or \code{"log10"} (default depends on \code{param_space} used for fitting).}

\item{...}{Additional arguments (passed to summary.nlme)}
}
\value{
A \code{summary.beezdemand_nlme} object (inherits from
\code{beezdemand_summary}) with fields including:
\itemize{
\item \code{call}: The original function call
\item \code{model_class}: "beezdemand_nlme"
\item \code{backend}: "nlme"
\item \code{equation_form}: The equation form used ("zben" or "simplified")
\item \code{coefficients}: Tibble of fixed effects with std.error, statistic, p.value
\item \code{random_effects}: VarCorr output for random effects
\item \code{logLik}, \code{AIC}, \code{BIC}: Model fit statistics
}
}
\description{
Returns a structured summary object containing model coefficients,
fit statistics, and random effects information.
}
