% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans.R
\name{scale_ll4}
\alias{scale_ll4}
\title{Create an LL4-like Scale for ggplot2 Axes}
\usage{
scale_ll4(..., lambda = 4)
}
\arguments{
\item{...}{Arguments passed on to \code{ggplot2::scale_y_continuous} or
\code{ggplot2::scale_x_continuous} (e.g., \code{name}, \code{breaks}, \code{labels}).}

\item{lambda}{A positive numeric scalar, the lambda parameter for the \code{ll4}
transformation. Default is \code{4}.}
}
\value{
A \code{ggplot2} scale object.
}
\description{
This function generates a \code{ggplot2} continuous scale that applies the \code{ll4}
transformation (and its inverse \code{ll4_inv}) to an axis. This is useful for
visualizing data spanning multiple orders of magnitude while handling zeros.
}
\examples{
\donttest{
if (require(ggplot2) && require(scales)) {
  set.seed(123)
  df <- data.frame(
    x = 1:100,
    y_raw = c(0, 0.1, 0.5, 1, 5, 10, 50, 100, 500, 1000, sample(1:2000, 90, replace = TRUE))
  )

  # Plot with y-axis on LL4 scale
  ggplot(df, aes(x = x, y = y_raw)) +
    geom_point() +
    scale_ll4(name = "Y-axis (LL4 Scale)", lambda = 4) +
    ggtitle("Data with LL4 Transformed Y-Axis")

  # Can also be used for x-axis by replacing scale_y_continuous in its definition
  # Or by creating a scale_x_ll4 variant.
}
}
}
\seealso{
\code{\link{ll4}}, \code{\link{ll4_inv}}, \code{\link[scales]{trans_new}}
}
