% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle-simulate.R
\name{run_hurdle_monte_carlo}
\alias{run_hurdle_monte_carlo}
\title{Run Monte Carlo Simulation Study for Hurdle Demand Model}
\usage{
run_hurdle_monte_carlo(
  n_sim = 100,
  n_subjects = 100,
  true_params = NULL,
  n_random_effects = 2,
  prices = seq(0, 11, by = 0.5),
  stop_at_zero = TRUE,
  verbose = TRUE,
  seed = NULL
)
}
\arguments{
\item{n_sim}{Number of simulated datasets. Default is 100.}

\item{n_subjects}{Number of subjects per dataset. Default is 100.}

\item{true_params}{Named list of true parameter values. If NULL, defaults
are used from \code{\link{simulate_hurdle_data}}.}

\item{n_random_effects}{Number of random effects (2 or 3). Default is 2.}

\item{prices}{Numeric vector of prices. Default is seq(0, 11, by = 0.5).}

\item{stop_at_zero}{Logical; if TRUE in simulation, subjects stop after first
zero. Default is TRUE.}

\item{verbose}{Logical; print progress. Default is TRUE.}

\item{seed}{Random seed for reproducibility.}
}
\value{
A list with:
\describe{
\item{estimates}{Data frame of parameter estimates from each simulation}
\item{true_params}{True parameter values used}
\item{summary}{Summary statistics including bias, SE ratio, and coverage}
\item{n_converged}{Number of simulations that converged}
\item{n_sim}{Total number of simulations attempted}
}
}
\description{
Runs a Monte Carlo simulation study to assess model performance,
including bias, standard error estimates, and confidence interval coverage.
}
\examples{
\donttest{
# Run small simulation study (for demonstration)
mc_results <- run_hurdle_monte_carlo(n_sim = 10, n_subjects = 50, seed = 123)

# View summary
print(mc_results$summary)

# Check convergence rate
cat("Convergence rate:", mc_results$n_converged / mc_results$n_sim, "\n")
}

}
\seealso{
\code{\link{simulate_hurdle_data}}, \code{\link{fit_demand_hurdle}}
}
