% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans.R
\name{pseudo_ll4_trans}
\alias{pseudo_ll4_trans}
\title{Create a Pseudo-Log LL4 Transformation Object for ggplot2}
\usage{
pseudo_ll4_trans(lambda = 4)
}
\arguments{
\item{lambda}{A positive numeric scalar, the lambda parameter for the \code{ll4}
transformation. Default is \code{4}.}
}
\value{
A \code{trans} object (from the \code{scales} package).
}
\description{
Generates a \code{scales::trans} object using the \code{ll4} transformation.
This transformation object can be passed to the \code{trans} argument of
\code{ggplot2::scale_x_continuous} or \code{ggplot2::scale_y_continuous}.
It's designed for non-negative data and handles zero values gracefully.
The "pseudo" aspect is conceptual, similar to \code{pseudo_log_trans} in that it
handles a range including zero, but the transformation is \code{ll4}.
}
\examples{
\donttest{
if (require(ggplot2) && require(scales)) {
  set.seed(123)
  df <- data.frame(
    x_vals = c(0, 0.01, 0.1, 1, 10, 100, 1000, NA), # Include 0 and NA
    y_vals = c(0, 10, 50, 100, 500, 1000, 2000, 50)
  )

  # Using pseudo_ll4_trans for the y-axis
  ggplot(df, aes(x = x_vals, y = y_vals)) +
    geom_point() +
    scale_y_continuous(trans = pseudo_ll4_trans(lambda = 4),
                       name = "Y-Values (Pseudo-LL4 Scale)") +
    ggtitle("Y-Axis with Pseudo-LL4 Transformation")

  # Using pseudo_ll4_trans for the x-axis
  ggplot(df, aes(x = x_vals, y = y_vals)) +
    geom_point() +
    scale_x_continuous(trans = pseudo_ll4_trans(lambda = 2), # Different lambda
                       name = "X-Values (Pseudo-LL4 Scale)") +
    ggtitle("X-Axis with Pseudo-LL4 Transformation")
}
}
}
\seealso{
\code{\link{ll4}}, \code{\link{ll4_inv}}, \code{\link[scales]{trans_new}}
}
