% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp-methods.R
\name{predict.cp_model_lmer}
\alias{predict.cp_model_lmer}
\title{Predict from a Mixed-Effects Cross-Price Demand Model}
\usage{
\method{predict}{cp_model_lmer}(object, newdata = NULL, pred_type = c("fixed", "random"), ...)
}
\arguments{
\item{object}{A \code{cp_model_lmer} object (as returned by \code{fit_cp_linear(type = "mixed", ...)}).}

\item{newdata}{A data frame containing at least an \code{x} column. For \code{pred_type = "random"},
an \code{id} column is required. If absent, the function extracts unique ids from \code{object$data}
and expands the grid accordingly. If no ids are available, a default id of 1 is used (with a warning).}

\item{pred_type}{Character string specifying the type of prediction: either \code{"fixed"} (population-level)
or \code{"random"} (subject-specific). The default is \code{"fixed"}.}

\item{...}{Additional arguments passed to the underlying \code{predict} function.}
}
\value{
A data frame containing all columns of \code{newdata} plus a column \code{y_pred}
with the corresponding predictions.
}
\description{
Generates predictions from a mixed-effects cross-price demand model (of class
\code{cp_model_lmer}). The function supports two modes:
}
\details{
\describe{
\item{\code{"fixed"}}{Returns predictions based solely on the fixed-effects component
(using \code{re.form = NA}).}
\item{\code{"random"}}{Returns subject-specific predictions (fixed plus random effects)
(using \code{re.form = NULL}).}
}
}
\examples{
\donttest{
data(etm)
fit <- fit_cp_linear(etm, type = "mixed")
new_prices <- data.frame(x = c(2, 4, 8, 16, 32, 64))
predict(fit, newdata = new_prices, pred_type = "fixed")
}

}
