% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed-methods.R
\name{predict.beezdemand_nlme}
\alias{predict.beezdemand_nlme}
\title{Predict Method for beezdemand_nlme Objects}
\usage{
\method{predict}{beezdemand_nlme}(
  object,
  newdata = NULL,
  type = c("response", "link", "population", "individual"),
  level = 0,
  inv_fun = identity,
  se.fit = FALSE,
  interval = c("none", "confidence"),
  interval_level = 0.95,
  ...
)
}
\arguments{
\item{object}{A \code{beezdemand_nlme} object.}

\item{newdata}{Optional data frame for which to make predictions.
Must contain \code{x_var} and all \code{factors} specified in the original model.
If group-level predictions are desired (\code{level=1}), the \code{id_var} column from
the original fit must also be present in \code{newdata} and its levels should
correspond to those in the original data for meaningful random effect application.
If \code{NULL}, predictions are made for the data used in fitting the model.}

\item{type}{One of \code{"response"} (default), \code{"link"}, \code{"population"}, or \code{"individual"}.
\code{"population"} and \code{"individual"} are aliases that set \code{level} to \code{0} or \code{1},
respectively.}

\item{level}{Integer, prediction level for \code{nlme::predict.nlme()}:
\itemize{
\item \code{0}: Population predictions (based on fixed effects only).
\item \code{1} (or higher, up to number of grouping levels in model): Group-specific
predictions (fixed effects + random effects for the specified \code{id_var} level).
}
Default is \code{0}.}

\item{inv_fun}{Optional function to inverse-transform the predictions.
Example: If \code{y_var} was log10-transformed during fitting and \code{equation_form}
like "zben" produces predictions on that log10 scale, \code{inv_fun = function(x) 10^x}
would convert predictions back to the original consumption scale.
If \code{equation_form} was "simplified" (which models raw Y), \code{inv_fun} might be \code{identity}
or not needed if predictions are already on the desired scale.}

\item{se.fit}{Logical; if \code{TRUE}, includes a \code{.se.fit} column (currently \code{NA}
because standard errors are not implemented for \code{beezdemand_nlme} predictions).}

\item{interval}{One of \code{"none"} (default) or \code{"confidence"}. When requested,
\code{.lower}/\code{.upper} are returned as \code{NA}.}

\item{interval_level}{Confidence level when \code{interval = "confidence"}. Currently
used only for validation.}

\item{...}{Additional arguments passed to \code{nlme::predict.nlme()}.}
}
\value{
A tibble containing the original \code{newdata} columns plus \code{.fitted}.
When requested, \code{.se.fit} and \code{.lower}/\code{.upper} are included (currently \code{NA}).
}
\description{
Generates point predictions from a fitted \code{beezdemand_nlme} model.
Predictions can be made at the population level (fixed effects only) or
group/subject level (fixed + random effects). The output scale depends
on the \code{equation_form} used during model fitting and whether \code{inv_fun} is applied.
}
\examples{
\donttest{
data(ko)
fit <- fit_demand_mixed(ko, y_var = "y_ll4", x_var = "x",
                        id_var = "monkey", equation_form = "zben")
# Population-level predictions
preds <- predict(fit, level = 0)

# Subject-level predictions
preds_subj <- predict(fit, level = 1)
}
}
\seealso{
\code{\link[nlme]{predict.nlme}}
}
