% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle-methods.R
\name{predict.beezdemand_hurdle}
\alias{predict.beezdemand_hurdle}
\title{Predict Method for Hurdle Demand Models}
\usage{
\method{predict}{beezdemand_hurdle}(
  object,
  newdata = NULL,
  type = c("response", "link", "parameters", "probability", "demand"),
  prices = NULL,
  se.fit = FALSE,
  interval = c("none", "confidence"),
  level = 0.95,
  ...
)
}
\arguments{
\item{object}{An object of class \code{beezdemand_hurdle}.}

\item{newdata}{Optional data frame containing a price column matching the fitted
object's \code{x_var}. If \code{newdata} includes the id column, subject-specific
predictions are returned; otherwise population predictions are returned.
If \code{newdata} is \code{NULL}, returns predictions for all subjects across a price grid.}

\item{type}{One of:
\describe{
\item{\code{"response"}}{Predicted consumption (part II)}
\item{\code{"link"}}{Predicted log-consumption (linear predictor of part II)}
\item{\code{"probability"}}{Predicted probability of zero consumption (part I)}
\item{\code{"demand"}}{Predicted expected consumption = (1 - P0) * response}
\item{\code{"parameters"}}{Subject-specific parameters (no \code{.fitted} column)}
}}

\item{prices}{Optional numeric vector of prices used only when \code{newdata = NULL}.}

\item{se.fit}{Logical; if \code{TRUE}, includes a \code{.se.fit} column (delta-method via
\code{sdreport} when available).}

\item{interval}{One of \code{"none"} (default) or \code{"confidence"}.}

\item{level}{Confidence level when \code{interval = "confidence"}.}

\item{...}{Unused.}
}
\value{
For \code{type = "parameters"}, a tibble of subject-level parameters.
Otherwise, a tibble containing the \code{newdata} columns plus \code{.fitted} and
helper columns \code{predicted_log_consumption}, \code{predicted_consumption},
\code{prob_zero}, and \code{expected_consumption}. When requested, \code{.se.fit} and
\code{.lower}/\code{.upper} are included.
}
\description{
Returns predictions from a fitted hurdle demand model.
}
\examples{
\donttest{
data(apt)
fit <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id")

# Get subject-specific parameters
pars <- predict(fit, type = "parameters")

# Predict demand at specific prices
demand <- predict(fit, type = "demand", prices = c(0, 0.5, 1, 2, 5))
}

}
