% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed-methods.R
\name{predict.beezdemand_fixed}
\alias{predict.beezdemand_fixed}
\title{Predict Method for beezdemand_fixed}
\usage{
\method{predict}{beezdemand_fixed}(
  object,
  newdata = NULL,
  type = c("response", "link"),
  se.fit = FALSE,
  interval = c("none", "confidence"),
  level = 0.95,
  ...
)
}
\arguments{
\item{object}{A \code{beezdemand_fixed} object.}

\item{newdata}{A data frame containing a price column matching the fitted
object's \code{x_var}. If \code{NULL}, uses the unique observed prices when available.}

\item{type}{One of \code{"response"} (default) or \code{"link"}.}

\item{se.fit}{Logical; if \code{TRUE}, includes a \code{.se.fit} column (currently \code{NA}
because vcov is not available from legacy fixed fits).}

\item{interval}{One of \code{"none"} (default) or \code{"confidence"}. When requested,
\code{.lower}/\code{.upper} are returned as \code{NA} because vcov is unavailable.}

\item{level}{Confidence level when \code{interval = "confidence"}. Currently used
only for validation.}

\item{...}{Unused.}
}
\value{
A tibble containing the original \code{newdata} columns, plus \code{.fitted}
and, when requested, \code{.se.fit} and \code{.lower}/\code{.upper}. If \code{newdata} does not
include an id column, predictions are returned for all subjects (cross
product of \code{newdata} × subjects) unless \code{k} is subject-specific (\code{k = "ind"}).
}
\description{
Predict Method for beezdemand_fixed
}
