% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle-methods.R
\name{plot_subject}
\alias{plot_subject}
\title{Plot Demand Curve for a Single Subject}
\usage{
plot_subject(
  object,
  subject_id,
  prices = NULL,
  show_data = TRUE,
  show_population = TRUE,
  style = c("modern", "apa")
)
}
\arguments{
\item{object}{An object of class \code{beezdemand_hurdle}.}

\item{subject_id}{The ID of the subject to plot.}

\item{prices}{Numeric vector of prices for plotting. If \code{NULL},
uses a sequence from 0 to max observed price.}

\item{show_data}{Logical; if \code{TRUE}, overlay observed data points.
Default is \code{TRUE}.}

\item{show_population}{Logical; if \code{TRUE}, show population curve.
Default is \code{TRUE}.}

\item{style}{Plot styling, passed to \code{theme_beezdemand()}.}
}
\value{
A ggplot2 object.
}
\description{
Creates a demand curve plot for a single subject with optional observed data
and population reference curve.
}
\examples{
\donttest{
data(apt)
fit <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id")
plot_subject(fit, subject_id = "19")
}

}
