% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{plot_residuals}
\alias{plot_residuals}
\title{Plot Residual Diagnostics}
\usage{
plot_residuals(object, type = c("all", "fitted", "histogram", "qq"), ...)
}
\arguments{
\item{object}{A fitted model object.}

\item{type}{Character; type of residual plot. One of:
\itemize{
\item \code{"fitted"}: Residuals vs fitted values
\item \code{"histogram"}: Histogram of residuals
\item \code{"qq"}: Q-Q plot of residuals
\item \code{"all"}: All plots combined (default)
}}

\item{...}{Additional arguments passed to plotting functions.}
}
\value{
A ggplot2 object or list of ggplot2 objects.
}
\description{
Creates diagnostic plots for model residuals including residuals vs fitted,
scale-location, and histogram of residuals.
}
\examples{
\donttest{
data(apt)
fit <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id")
plot_residuals(fit)
}

}
