% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{plot_qq}
\alias{plot_qq}
\alias{plot_qq.beezdemand_hurdle}
\alias{plot_qq.beezdemand_nlme}
\title{Plot Random Effects Q-Q}
\usage{
plot_qq(object, which = NULL, ...)

\method{plot_qq}{beezdemand_hurdle}(object, which = NULL, ...)

\method{plot_qq}{beezdemand_nlme}(object, which = NULL, ...)
}
\arguments{
\item{object}{A fitted model object with random effects (\code{beezdemand_hurdle}
or \code{beezdemand_nlme}).}

\item{which}{Character vector; which random effects to plot. Default is all.}

\item{...}{Additional arguments (ignored).}
}
\value{
A ggplot2 object.
}
\description{
Creates Q-Q plots for random effects to assess normality assumptions.
}
\examples{
\donttest{
data(apt)
fit <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id")
plot_qq(fit)
}

}
