% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp-methods.R
\name{plot.cp_model_lmer}
\alias{plot.cp_model_lmer}
\title{Plot Method for Mixed-Effects Cross-Price Demand Models}
\usage{
\method{plot}{cp_model_lmer}(
  x,
  data = NULL,
  inv_fun = identity,
  n_points = 100,
  title = NULL,
  xlab = "Price",
  ylab = "Consumption",
  x_trans = "identity",
  y_trans = "identity",
  point_size = 3,
  pred_type = c("fixed", "random", "all"),
  ...
)
}
\arguments{
\item{x}{A \code{cp_model_lmer} object (as returned by
\code{fit_cp_linear(type = "mixed", ...)}).}

\item{data}{Optional data frame containing columns \code{x} and \code{y} to be plotted.
If not provided, \code{object$data} is used.}

\item{inv_fun}{Optional function to inverse-transform predictions. Default is \code{identity}.
Not typically used for linear models but included for API consistency.}

\item{n_points}{Number of points to use in creating the prediction grid. Default is \code{100}.}

\item{title}{Optional title for the plot; default is \code{NULL}.}

\item{xlab}{Label for the x-axis. Default is \code{"Price"}.}

\item{ylab}{Label for the y-axis. Default is \code{"Consumption"}.}

\item{x_trans}{Transformation for the x-axis; one of \code{"identity"}, \code{"log10"}, or
\code{"pseudo_log"}. Default is \code{"identity"}.}

\item{y_trans}{Transformation for the y-axis; one of \code{"identity"}, \code{"log10"}, or
\code{"pseudo_log"}. Default is \code{"identity"}.}

\item{point_size}{Size of the observed data points. Default is \code{3}.}

\item{pred_type}{Character string specifying which prediction components to plot:
\describe{
\item{\code{"fixed"}}{Plot only the fixed-effects (population) prediction.}
\item{\code{"random"}}{Plot only the subject-specific predictions.}
\item{\code{"all"}}{Plot both the fixed-effects and the subject-specific predictions.}
}
The default is \code{"fixed"}.}

\item{...}{Additional arguments passed to \code{\link{predict.cp_model_lmer}}.}
}
\value{
A ggplot2 object displaying the observed data points along with the prediction curves.
}
\description{
Creates a ggplot2 visualization of a fitted mixed-effects cross-price demand model
(of class \code{cp_model_lmer}). This function allows you to plot:
}
\details{
\describe{
\item{\code{"fixed"}}{Only the population-level (fixed-effects) prediction.}
\item{\code{"random"}}{Only the subject-specific predictions.}
\item{\code{"all"}}{Both: the fixed-effects and the subject-specific predictions.}
}

If the model includes group effects, separate lines will be drawn for each group.
}
