% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp-methods.R
\name{plot.cp_model_lm}
\alias{plot.cp_model_lm}
\title{Plot Method for Linear Cross-Price Demand Models}
\usage{
\method{plot}{cp_model_lm}(
  x,
  data = NULL,
  inv_fun = identity,
  n_points = 100,
  title = NULL,
  xlab = "Price",
  ylab = "Consumption",
  x_trans = "identity",
  y_trans = "identity",
  point_size = 3,
  ...
)
}
\arguments{
\item{x}{A \code{cp_model_lm} object (as returned by \code{fit_cp_linear(type = "fixed", ...)}).}

\item{data}{Optional data frame containing columns \code{x} and \code{y} to plot.
If not provided, the function uses \code{object$data} if available.}

\item{inv_fun}{Optional function to inverse-transform predictions. Default is \code{identity}.
Not typically used for linear models but included for API consistency.}

\item{n_points}{Number of points to create in the prediction grid. Default is \code{100}.}

\item{title}{Optional title for the plot; default is \code{NULL}.}

\item{xlab}{Label for the x-axis. Default is \code{"Price"}.}

\item{ylab}{Label for the y-axis. Default is \code{"Consumption"}.}

\item{x_trans}{Transformation for the x-axis; one of \code{"identity"}, \code{"log10"}, or \code{"pseudo_log"}.
Default is \code{"identity"}.}

\item{y_trans}{Transformation for the y-axis; one of \code{"identity"}, \code{"log10"}, or \code{"pseudo_log"}.
Default is \code{"identity"}.}

\item{point_size}{Size of the data points in the plot. Default is \code{3}.}

\item{...}{Additional arguments passed to the generic \code{predict} method.}
}
\value{
A ggplot2 object displaying the fitted model predictions and observed data.
}
\description{
Creates a ggplot2 visualization of a fitted linear cross-price demand model
(of class \code{cp_model_lm}). The plot overlays a prediction line over the
observed data points. Axis transformations (e.g., \code{"log10"}) can be applied.
If the model includes group effects, separate lines will be drawn for each group.
}
