% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed-methods.R
\name{plot.beezdemand_nlme}
\alias{plot.beezdemand_nlme}
\title{Plot Method for beezdemand_nlme Objects}
\usage{
\method{plot}{beezdemand_nlme}(
  x,
  type = c("demand", "population", "individual", "both"),
  ids = NULL,
  show_observed = TRUE,
  observed_point_alpha = 0.6,
  show_pred = "population",
  n_points = 200,
  inv_fun = identity,
  facet = NULL,
  at = NULL,
  color_by = NULL,
  linetype_by = NULL,
  shape_by = NULL,
  x_trans = c("log10", "log", "linear", "pseudo_log"),
  y_trans = NULL,
  free_trans = 0.01,
  x_limits = NULL,
  y_limits = NULL,
  style = c("modern", "apa"),
  title = NULL,
  subtitle = NULL,
  x_lab = NULL,
  y_lab = NULL,
  xlab = NULL,
  ylab = NULL,
  observed_point_size = 2,
  pop_line_size = 1,
  ind_line_size = 0.6,
  pop_line_alpha = 0.9,
  ind_line_alpha = 0.3,
  ...
)
}
\arguments{
\item{x}{A \code{beezdemand_nlme} object.}

\item{type}{Plot type: "demand", "population", "individual", or "both".}

\item{ids}{Optional vector of subject IDs to plot.}

\item{show_observed}{Logical. If TRUE, plots the original data points. Default \code{TRUE}.}

\item{observed_point_alpha}{Alpha for observed points. Default \code{0.6}.}

\item{show_pred}{Which prediction layers to plot: "population", "individual",
or "both".}

\item{n_points}{Integer. Number of points for prediction lines. Default \code{100}.}

\item{inv_fun}{Optional function to inverse-transform y-axis and predictions. Default \code{identity}.}

\item{facet}{Optional faceting formula (e.g., \code{~ dose}).}

\item{at}{Optional named list giving values for continuous covariates used in the
fixed-effects RHS. When building prediction grids for population- or individual-
level lines, these values will be used. If not provided, the function will
default to the median of each continuous covariate found in the original
model data. Factor variables are always handled as grids (population) or
observed combinations (individual) as before.}

\item{color_by}{Optional character string: name of a factor to color lines and/or points by.
Must be a column in \code{x$data}.}

\item{linetype_by}{Optional character string: name of a factor for linetypes of population prediction lines
if individual lines are also shown (otherwise applies to the shown lines).
Must be a model factor in \code{x$param_info$factors}.}

\item{shape_by}{Optional character string: name of a factor for shapes of observed points.
Must be a column in \code{x$data}.}

\item{x_trans}{Character. Transformation for x-axis. Default "log".}

\item{y_trans}{Character. Transformation for y-axis. Default "log".}

\item{free_trans}{Value used to display free (x = 0) on log scales. Use NULL
to drop x <= 0 values instead.}

\item{x_limits}{Optional numeric vector of length 2 for x-axis limits.}

\item{y_limits}{Optional numeric vector of length 2 for y-axis limits.}

\item{style}{Plot styling, passed to \code{theme_beezdemand()}.}

\item{title}{Optional plot title.}

\item{subtitle}{Optional subtitle for the plot.}

\item{x_lab}{Optional x-axis label.}

\item{y_lab}{Optional y-axis label.}

\item{xlab}{Deprecated alias for \code{x_lab}.}

\item{ylab}{Deprecated alias for \code{y_lab}.}

\item{observed_point_size}{Size for observed points. Default \code{2}.}

\item{pop_line_size}{Size for population prediction lines. Default \code{1}.}

\item{ind_line_size}{Size for individual prediction lines. Default \code{0.6}.}

\item{pop_line_alpha}{Alpha for population prediction lines. Default \code{0.9}.}

\item{ind_line_alpha}{Alpha for individual prediction lines. Default \code{0.3}.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A ggplot2 object.
}
\description{
Creates a ggplot2 visualization of a fitted \code{beezdemand_nlme} model,
showing observed data points and/or model prediction lines.
}
