% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed-methods.R
\name{plot.beezdemand_fixed}
\alias{plot.beezdemand_fixed}
\title{Plot Method for beezdemand_fixed}
\usage{
\method{plot}{beezdemand_fixed}(
  x,
  type = c("demand", "population", "individual", "both"),
  ids = NULL,
  style = c("modern", "apa"),
  show_observed = TRUE,
  show_pred = NULL,
  x_trans = c("log10", "log", "linear", "pseudo_log"),
  y_trans = NULL,
  free_trans = 0.01,
  x_limits = NULL,
  y_limits = NULL,
  n_points = 200,
  x_lab = NULL,
  y_lab = NULL,
  xlab = NULL,
  ylab = NULL,
  facet = NULL,
  observed_point_alpha = 0.5,
  observed_point_size = 1.8,
  pop_line_alpha = 0.9,
  pop_line_size = 1,
  ind_line_alpha = 0.35,
  ind_line_size = 0.7,
  subtitle = NULL,
  ...
)
}
\arguments{
\item{x}{A beezdemand_fixed object.}

\item{type}{Plot type: "demand", "population", "individual", or "both".}

\item{ids}{Optional vector of subject IDs to plot. Defaults to all subjects.}

\item{style}{Plot styling, passed to \code{theme_beezdemand()}.}

\item{show_observed}{Logical; if TRUE, overlay observed data points where possible.}

\item{show_pred}{Which prediction layers to plot: "population", "individual",
or "both".}

\item{x_trans}{X-axis transform: "log", "log10", "linear", or "pseudo_log".}

\item{y_trans}{Y-axis transform: "log", "log10", "linear", or "pseudo_log".}

\item{free_trans}{Value used to display free (x = 0) on log scales. Use NULL
to drop x <= 0 values instead.}

\item{x_limits}{Optional numeric vector of length 2 for x-axis limits.}

\item{y_limits}{Optional numeric vector of length 2 for y-axis limits.}

\item{n_points}{Number of points to use for prediction curves when thinning.}

\item{x_lab}{Optional x-axis label.}

\item{y_lab}{Optional y-axis label.}

\item{xlab}{Deprecated alias for \code{x_lab}.}

\item{ylab}{Deprecated alias for \code{y_lab}.}

\item{facet}{Faceting specification (TRUE for \code{~id} or a formula).}

\item{observed_point_alpha}{Alpha for observed points.}

\item{observed_point_size}{Size for observed points.}

\item{pop_line_alpha}{Alpha for population curve.}

\item{pop_line_size}{Line size for population curve.}

\item{ind_line_alpha}{Alpha for individual curves.}

\item{ind_line_size}{Line size for individual curves.}

\item{subtitle}{Optional subtitle for the plot.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A ggplot2 object.
}
\description{
Plot Method for beezdemand_fixed
}
