% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot-demand-data.R
\name{pivot_demand_data}
\alias{pivot_demand_data}
\title{Reshape Demand Data Between Wide and Long Formats}
\usage{
pivot_demand_data(
  data,
  format = c("long", "wide"),
  id_var = "id",
  x_var = "x",
  y_var = "y",
  price_cols = NULL,
  x_values = NULL,
  drop_na = TRUE
)
}
\arguments{
\item{data}{A data frame or tibble to reshape.}

\item{format}{Character. Direction of reshaping: \code{"long"} (wide to long) or
\code{"wide"} (long to wide). Default \code{"long"}.}

\item{id_var}{Character. Name of the subject/series identifier column.
Default \code{"id"}.}

\item{x_var}{Character. Name of the price column in long-format data. Used
when \code{format = "wide"}. Default \code{"x"}.}

\item{y_var}{Character. Name of the consumption column in long-format data.
Used when \code{format = "wide"}. Default \code{"y"}.}

\item{price_cols}{Character vector of column names in wide-format data that
represent prices. Used when \code{format = "long"}. Default \code{NULL}, which
auto-detects: columns whose names parse as numeric become price columns,
and remaining columns (besides \code{id_var}) are preserved as identifiers.
If no column names parse as numeric, all non-\code{id_var} columns are treated
as price columns (and \code{x_values} must be supplied).}

\item{x_values}{Numeric vector of actual price values corresponding to each
price column in wide-format data. Used when \code{format = "long"}. Must be the
same length as the number of price columns. Default \code{NULL}, which parses
prices from column names.}

\item{drop_na}{Logical. When \code{format = "long"}, drop rows where consumption
(\code{y}) is \code{NA} after pivoting? Default \code{TRUE}. A warning is issued when rows
are dropped.}
}
\value{
A tibble. When \code{format = "long"}: columns \code{id}, any extra identifier
columns, \code{x} (numeric price), and \code{y} (numeric consumption). When
\code{format = "wide"}: one row per subject with prices as column names.
}
\description{
Converts demand data between wide format (one row per subject,
prices as columns) and long format (one row per observation with \code{id}, \code{x},
\code{y} columns). This is a convenience wrapper around \code{\link[tidyr:pivot_longer]{tidyr::pivot_longer()}}
and \code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}} tailored for behavioral economic purchase task
data.
}
\details{
\subsection{Wide to Long (\code{format = "long"})}{

The function determines which columns are price columns by:
\enumerate{
\item If \code{price_cols} is provided, those columns are used directly.
\item If \code{price_cols} is \code{NULL}, column names are tested with \code{as.numeric()}.
Columns whose names successfully parse as numbers (e.g., \code{"0"}, \code{"0.5"},
\code{"10"}) are treated as price columns. Remaining non-\code{id_var} columns are
preserved as extra identifiers.
\item If no column names parse as numeric, all non-\code{id_var} columns become price
columns and \code{x_values} must be supplied.
}

Actual numeric price values come from \code{x_values} if supplied, or from parsing
column names. If column names cannot be parsed and \code{x_values} is not supplied,
an error is raised.
}

\subsection{Long to Wide (\code{format = "wide"})}{

Pivots long data so that each unique value in \code{x_var} becomes a column, with
values from \code{y_var}. All columns except \code{x_var} and \code{y_var} are used as
identifiers.
}
}
\examples{
# --- Wide to long ---
# Columns named as prices (auto-parsed)
wide_num <- data.frame(
  id = 1:3,
  "0" = c(10, 8, 12), "0.5" = c(9, 7, 11), "1" = c(8, 6, 9),
  check.names = FALSE
)
pivot_demand_data(wide_num, format = "long")

# Columns with non-numeric names require x_values
wide_named <- data.frame(id = 1:2, price_1 = c(10, 8), price_2 = c(5, 4))
pivot_demand_data(wide_named, format = "long",
                  x_values = c(0, 0.5))

# --- Long to wide ---
data(apt, package = "beezdemand")
wide_apt <- pivot_demand_data(apt, format = "wide")
head(wide_apt)

}
