% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle-methods.R
\name{logLik.beezdemand_hurdle}
\alias{logLik.beezdemand_hurdle}
\title{Extract Log-Likelihood from Hurdle Demand Model}
\usage{
\method{logLik}{beezdemand_hurdle}(object, ...)
}
\arguments{
\item{object}{An object of class \code{beezdemand_hurdle}.}

\item{...}{Additional arguments (currently unused).}
}
\value{
An object of class \code{logLik} with the log-likelihood value
and attributes for degrees of freedom and number of observations.
}
\description{
Extracts the log-likelihood from a fitted hurdle demand model.
Useful for likelihood ratio tests comparing nested models.
}
\examples{
\donttest{
data(apt)
fit <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id")
logLik(fit)
}

}
