% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans.R
\name{ll4_inv}
\alias{ll4_inv}
\title{Inverse Log-Logistic Transformation (Inverse LL4-like)}
\usage{
ll4_inv(y, lambda = 4, base = 10)
}
\arguments{
\item{y}{A numeric vector or scalar of transformed values (output from \code{ll4}).}

\item{lambda}{A positive numeric scalar, the lambda parameter used in the original
\code{ll4} transformation. Must match the one used for the forward transform. Default is \code{4}.}

\item{base}{A positive numeric scalar, the base of the logarithm used in the
original \code{ll4} transformation. Must match. Default is \code{10}.}
}
\value{
A numeric vector or scalar of the original, untransformed values.
May return \code{NaN} if \code{(base^(y * lambda) - 1)} is negative and \code{1/lambda} implies
an even root (e.g., if \code{lambda} is 2 or 4).
}
\description{
Applies the inverse of the \code{ll4} transformation.
Given \code{y = ll4(x)}, this function calculates \code{x = (base^(y * lambda) - 1)^(1/lambda)}.
}
\examples{
original_values <- c(0, 1, 10, 100, 1000)
transformed_values <- ll4(original_values)
back_transformed_values <- ll4_inv(transformed_values)
print(data.frame(original_values, transformed_values, back_transformed_values))
all.equal(original_values, back_transformed_values) # Should be TRUE or very close

# Example with negative y (log-transformed value)
# If y_ll4 = -0.5 (meaning original value was between 0 and 1 for log10)
ll4_inv(-0.5, lambda = 4, base = 10) # (10^(-0.5*4) - 1)^(1/4) = (0.01 - 1)^(1/4) -> NaN
# The ll4_inv function as provided will return NaN here.
# A more robust version for demand might floor at 0 if NaN occurs.
}
