% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans.R
\name{ll4}
\alias{ll4}
\title{Log-Logistic Transformation (LL4-like)}
\usage{
ll4(x, lambda = 4, base = 10)
}
\arguments{
\item{x}{A numeric vector or scalar of non-negative values to be transformed.}

\item{lambda}{A positive numeric scalar, the lambda parameter of the transformation.
Controls the curvature. Default is \code{4}.}

\item{base}{A positive numeric scalar, the base of the logarithm. Default is \code{10}.}
}
\value{
A numeric vector or scalar of the transformed values.
Returns \code{NaN} for \code{x < 0} if \code{lambda} results in non-real numbers (e.g., even root of negative).
However, the intended domain is \code{x >= 0}.
}
\description{
Applies a log-logistic like transformation, specifically \code{log_base(x^lambda + 1) / lambda}.
This transformation is useful for compressing data that spans several orders of
magnitude while handling zero values gracefully (as \code{x=0} yields \code{0}).
It's a variation related to the Box-Cox transformation or a generalized logarithm.
}
\examples{
ll4(0)
ll4(1)
ll4(10)
ll4(100)
ll4(c(0, 1, 10, 100, 1000))

# Using a different lambda or base
ll4(10, lambda = 2)
ll4(10, base = exp(1)) # Natural log base
}
