% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp-methods.R
\name{glance.cp_model_nls}
\alias{glance.cp_model_nls}
\title{Get model summaries from a cross-price model}
\usage{
\method{glance}{cp_model_nls}(x, ...)
}
\arguments{
\item{x}{A model object from fit_cp_nls or fit_cp_linear}

\item{...}{Additional arguments (unused)}
}
\value{
A one-row data frame with model summary statistics:
\item{r.squared}{R-squared value indicating model fit}
\item{aic}{Akaike Information Criterion}
\item{bic}{Bayesian Information Criterion}
\item{equation}{The equation type used in the model}
\item{method}{The method used to fit the model}
\item{transform}{The transformation applied to the data, if any}
}
\description{
This function extracts model summary statistics from a cross-price demand model
into a single-row data frame, following the conventions of the broom package.
It returns goodness-of-fit measures and other model information.
}
\examples{
\donttest{
data(etm)
fit <- fit_cp_nls(etm, equation = "exponentiated")
glance(fit)
}

}
