% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle-utils.R
\name{get_subject_pars}
\alias{get_subject_pars}
\title{Get Subject-Specific Parameters}
\usage{
get_subject_pars(object)
}
\arguments{
\item{object}{A fitted \code{beezdemand_hurdle} object.}
}
\value{
Data frame with subject-specific parameters including:
\describe{
\item{id}{Subject identifier}
\item{a_i}{Random effect for Part I (zeros)}
\item{b_i}{Random effect for Part II (Q0)}
\item{c_i}{Random effect for alpha (3-RE model only)}
\item{Q0}{Subject-specific intensity (consumption at price 0)}
\item{alpha}{Subject-specific elasticity}
\item{breakpoint}{Price where P(quit) = 0.5}
\item{Pmax}{Price at maximum expenditure}
\item{Omax}{Maximum expenditure}
}
}
\description{
Convenience function to extract subject-specific demand parameters from
a fitted hurdle demand model. Equivalent to accessing \code{object$subject_pars}.
}
\examples{
\donttest{
data(apt)
fit <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id")
pars <- get_subject_pars(fit)
head(pars)
}

}
\seealso{
\code{\link{fit_demand_hurdle}}
}
