% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed-methods.R
\name{get_observed_demand_param_emms}
\alias{get_observed_demand_param_emms}
\title{Get Estimated Marginal Means for Observed Factor Combinations}
\usage{
get_observed_demand_param_emms(
  fit_obj,
  factors_in_emm = NULL,
  at = NULL,
  ci_level = 0.95,
  include_ev = FALSE,
  ...
)
}
\arguments{
\item{fit_obj}{A \code{beezdemand_nlme} object returned by \code{fit_demand_mixed()}.}

\item{factors_in_emm}{Character vector of factor names to compute EMMs over.
Defaults to all factors present in the \code{fit_obj}. These factors define the
grid over which EMMs are initially calculated and then filtered.}

\item{at}{Optional named list specifying levels of conditioning variables for \code{emmeans::ref_grid()}.
Passed to \code{get_demand_param_emms}.}

\item{ci_level}{Confidence level for the EMMs (default 0.95).
Passed to \code{get_demand_param_emms}.}

\item{include_ev}{Logical. If TRUE, calculates and includes Essential Value (EV)
derived from alpha. Passed to \code{get_demand_param_emms}. Default \code{FALSE}.}

\item{...}{Additional arguments passed to \code{get_demand_param_emms} and subsequently
to \code{emmeans::emmeans()}.}
}
\value{
A tibble similar to the output of \code{get_demand_param_emms}, but filtered
to include only rows corresponding to factor level combinations that were
observed in the original \code{fit_obj$data}. Contains:
\item{Factor levels}{Columns for each factor in \code{factors_in_emm}.}
\item{Q0_param_log10, alpha_param_log10}{EMMs for model parameters (log10 scale) and CIs.}
\item{Q0_natural, alpha_natural}{EMMs back-transformed to natural scale and CIs.}
\item{EV, LCL_EV, UCL_EV}{(If \code{include_ev=TRUE}) Essential Value and its CI.}
}
\description{
This function is a wrapper around \code{get_demand_param_emms}. It first calls
\code{get_demand_param_emms} to calculate Estimated Marginal Means (EMMs) for
Q0 and alpha parameters over all combinations of the specified factor levels.
It then filters these results to return EMMs only for the combinations of
factor levels that were actually present in the original dataset used to
fit the \code{beezdemand_nlme} model.
}
\examples{
\donttest{
data(ko, package = "beezdemand")
ko$y_ll4 <- ll4(ko$y, lambda = 4)
fit <- fit_demand_mixed(ko, y_var = "y_ll4", x_var = "x",
  id_var = "monkey", factors = "dose", equation_form = "zben")
get_observed_demand_param_emms(fit)
}
}
\seealso{
\code{\link{get_demand_param_emms}}
}
