% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k-parameter.R
\name{get_k}
\alias{get_k}
\title{Calculate K Scaling Parameter for Demand Curve Fitting}
\usage{
get_k(
  data,
  use_means = TRUE,
  adjustment = 0.5,
  x_var = "x",
  y_var = "y",
  verbose = FALSE
)
}
\arguments{
\item{data}{A data frame in long format with columns for price and consumption}

\item{use_means}{Logical indicating whether to calculate k from mean consumption
by price (TRUE, default) or from individual consumption values (FALSE)}

\item{adjustment}{Numeric adjustment added to the log range (default: 0.5).
This value ensures k is slightly larger than the observed range.}

\item{x_var}{Character string specifying the column name for price (default: "x")}

\item{y_var}{Character string specifying the column name for consumption (default: "y")}

\item{verbose}{Logical indicating whether to print calculation details (default: FALSE)}
}
\value{
A single numeric value representing the k scaling parameter
}
\description{
Calculates the k scaling parameter used in demand curve equations to normalize
consumption across different units or ranges. The k value is derived from the
logarithmic range of consumption values.

This is the modern replacement for \code{\link[=GetK]{GetK()}}, with explicit parameters for
the adjustment value and optional verbose output.
}
\details{
The k parameter is calculated as:

\deqn{k = \log_{10}(\text{max}) - \log_{10}(\text{min}) + \text{adjustment}}{
      k = log10(max) - log10(min) + adjustment}

where max and min are the maximum and minimum non-zero consumption values.
\subsection{Use in Demand Equations}{

The k parameter appears in several demand curve equations:
\itemize{
\item \strong{Hursh & Silberberg (2008)}: Scales the exponential term
\item \strong{Koffarnus et al. (2015)}: Normalizes the exponentiated model
\item Ensures numerical stability during model fitting
}
}

\subsection{Calculation Modes}{

\itemize{
\item \strong{use_means = TRUE} (default): Calculates k from mean consumption
at each price point. Recommended when data has multiple subjects, as it
reduces influence of individual outliers.

\item \strong{use_means = FALSE}: Calculates k from the full range of individual
consumption values. May be preferable for single-subject data or when
individual variability is theoretically important.
}
}
}
\note{
\itemize{
\item Only non-zero consumption values are used (zero values are excluded)
\item Missing values (NA) are automatically removed via \code{na.rm = TRUE}
\item The default adjustment of 0.5 is conventional but can be modified
}
}
\examples{
\donttest{
data(apt, package = "beezdemand")

# Calculate k using default settings (mean range + 0.5)
k_val <- get_k(apt)

# Calculate k from individual values
k_ind <- get_k(apt, use_means = FALSE)

# Calculate with custom adjustment
k_custom <- get_k(apt, adjustment = 1.0)

# Show calculation details
k_verbose <- get_k(apt, verbose = TRUE)
}

}
\seealso{
\itemize{
\item \code{\link[=GetK]{GetK()}} - Legacy function (superseded)
\item \code{\link[=FitCurves]{FitCurves()}} - Uses k parameter in demand curve fitting
}
}
