% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed-methods.R
\name{get_individual_coefficients}
\alias{get_individual_coefficients}
\title{Calculate Individual-Level Predicted Coefficients from beezdemand_nlme Model}
\usage{
get_individual_coefficients(
  fit_obj,
  params = c("Q0", "alpha"),
  format = c("wide", "long")
)
}
\arguments{
\item{fit_obj}{A \code{beezdemand_nlme} object returned by \code{fit_demand_mixed()}.}

\item{params}{Character vector specifying which parameters to calculate.
Options are "Q0", "alpha", or c("Q0", "alpha"). Default is c("Q0", "alpha").}

\item{format}{Character, output format. "wide" returns one row per individual
with separate columns for each parameter-factor combination. "long" returns
one row per individual-parameter-factor combination. Default is "wide".}
}
\value{
A data frame with individual-level predicted coefficients.
\itemize{
\item In "wide" format: rows are individuals, columns are parameter-factor combinations
\item In "long" format: columns are id, parameter, condition, coefficient_value
}

Column naming convention for wide format:
\itemize{
\item \verb{estimated_\\\{param\\\}_intercept}: Baseline/reference level coefficient
\item \verb{estimated_\\\{param\\\}_\\\{factor\\\}\\\{level\\\}}: Factor level-specific coefficient
}

All coefficients are on the log10 scale (same as model estimation scale).
To convert to natural scale, use \code{10^coefficient}.
}
\description{
This function extracts and combines fixed and random effects to calculate
individual-level predicted coefficients for all parameter-factor combinations
from a beezdemand_nlme model object. It automatically detects the factor
structure and calculates coefficients for each individual and factor level.
}
\details{
Individual-level coefficients represent the predicted parameter values for each
subject in the study. For models with factors, these coefficients combine:
\enumerate{
\item The baseline intercept effect (fixed + random)
\item The factor-specific effect (fixed + random) for each factor level
}

This is equivalent to manually calculating:
\code{coefficient = intercept_fixed + intercept_random + factor_fixed + factor_random}

The function automatically handles:
\itemize{
\item Models with or without factors
\item Any number of factor levels
\item Missing random effects (defaults to 0)
\item Complex factor structures with multiple factors
}

For models without factors, only intercept coefficients are calculated.
For models with factors, both intercept and factor-level coefficients are provided.
}
\examples{
\donttest{
data(ko)
fit <- fit_demand_mixed(ko, y_var = "y_ll4", x_var = "x",
                        id_var = "monkey", factors = "drug",
                        equation_form = "zben")
individual_coefs <- get_individual_coefficients(fit)
head(individual_coefs)
}

}
\seealso{
\code{\link{fit_demand_mixed}} for fitting the original model
\code{\link{coef.beezdemand_nlme}} for extracting model coefficients
\code{\link{get_demand_param_emms}} for estimated marginal means
}
