% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle-utils.R
\name{get_hurdle_param_summary}
\alias{get_hurdle_param_summary}
\title{Get Hurdle Model Parameter Summary}
\usage{
get_hurdle_param_summary(fit_obj, ci_level = 0.95)
}
\arguments{
\item{fit_obj}{A \code{beezdemand_hurdle} object.}

\item{ci_level}{Confidence level for intervals (default 0.95).}
}
\value{
A data frame with summary statistics for each parameter:
\describe{
\item{parameter}{Parameter name}
\item{mean}{Mean across subjects}
\item{sd}{Standard deviation across subjects}
\item{median}{Median across subjects}
\item{lcl}{Lower confidence limit (based on percentiles)}
\item{ucl}{Upper confidence limit (based on percentiles)}
\item{min}{Minimum value}
\item{max}{Maximum value}
}
}
\description{
Provides summary statistics for subject-level demand parameters from a
hurdle demand model. This is analogous to EMMs but based on empirical
Bayes estimates of subject-specific parameters.
}
\examples{
\donttest{
data(apt)
fit <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id")
get_hurdle_param_summary(fit)
}

}
\seealso{
\code{\link{fit_demand_hurdle}}, \code{\link{get_subject_pars}}
}
