% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive-summary.R
\name{get_descriptive_summary}
\alias{get_descriptive_summary}
\title{Calculate Descriptive Statistics by Price}
\usage{
get_descriptive_summary(data, x_var = "x", y_var = "y", id_var = "id")
}
\arguments{
\item{data}{A data frame in long format with columns for subject ID, price, and consumption}

\item{x_var}{Character string specifying the column name for price (default: "x")}

\item{y_var}{Character string specifying the column name for consumption (default: "y")}

\item{id_var}{Character string specifying the column name for subject ID (default: "id")}
}
\value{
An S3 object of class \code{beezdemand_descriptive} containing:
\itemize{
\item \strong{statistics} - Data frame with 8 columns (Price, Mean, Median, SD,
PropZeros, NAs, Min, Max) and one row per unique price
\item \strong{call} - The matched call
\item \strong{data_summary} - List with n_subjects, n_prices, and prices vector
}
}
\description{
Calculates summary statistics for consumption data at each price point,
including measures of central tendency (mean, median), variability (SD),
range (min, max), and data quality (proportion of zeros, missing values).

This is the modern replacement for \code{\link[=GetDescriptives]{GetDescriptives()}}, returning a structured
S3 object with dedicated methods for printing, summarizing, and visualizing.
}
\details{
For each unique price in the dataset, the function calculates:
\itemize{
\item \strong{Mean} - Average consumption across subjects (rounded to 2 decimals)
\item \strong{Median} - Median consumption (rounded to 2 decimals)
\item \strong{SD} - Standard deviation (rounded to 2 decimals)
\item \strong{PropZeros} - Proportion of subjects with zero consumption (0-1)
\item \strong{NAs} - Count of missing values
\item \strong{Min} - Minimum consumption value (rounded to 2 decimals)
\item \strong{Max} - Maximum consumption value (rounded to 2 decimals)
}
}
\examples{
\donttest{
data(apt, package = "beezdemand")

# Calculate descriptive statistics
desc <- get_descriptive_summary(apt)
print(desc)

# View statistics table
desc$statistics

# Create visualization
plot(desc)

# Extended summary with distribution info
summary(desc)
}

}
\seealso{
\itemize{
\item \code{\link[=GetDescriptives]{GetDescriptives()}} - Legacy function (superseded)
\item \code{\link[=plot.beezdemand_descriptive]{plot.beezdemand_descriptive()}} - Visualization method
\item \code{\link[=summary.beezdemand_descriptive]{summary.beezdemand_descriptive()}} - Extended summary
}
}
