% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed-methods.R
\name{get_demand_param_emms}
\alias{get_demand_param_emms}
\title{Get Estimated Marginal Means for Demand Parameters}
\usage{
get_demand_param_emms(
  fit_obj,
  factors_in_emm = NULL,
  at = NULL,
  ci_level = 0.95,
  include_ev = FALSE,
  ...
)
}
\arguments{
\item{fit_obj}{A \code{beezdemand_nlme} object.}

\item{factors_in_emm}{Character vector of factor names to compute EMMs over.
Defaults to all factors present in the \code{fit_obj}.}

\item{at}{Optional named list specifying levels of conditioning variables for \code{emmeans::ref_grid()}.}

\item{ci_level}{Confidence level for the EMMs (default 0.95).}

\item{include_ev}{Logical. If TRUE, calculates and includes Essential Value (EV)
derived from alpha, along with its confidence interval (calculated by
back-transforming the CI of alpha_param_log10). Default \code{FALSE}.}

\item{...}{Additional arguments passed to \code{emmeans::emmeans()}.}
}
\value{
A tibble containing:
\item{Factor levels}{Columns for each factor in \code{factors_in_emm}.}
\item{Q0_param_log10, alpha_param_log10}{EMMs for the model parameters (log10 scale)
with their respective confidence intervals (LCL_Q0_param, UCL_Q0_param, etc.).}
\item{Q0_natural, alpha_natural}{EMMs back-transformed to the natural scale (10^param)
with their respective confidence intervals (LCL_Q0_natural, UCL_Q0_natural, etc.).}
\item{EV, LCL_EV, UCL_EV}{(If \code{include_ev=TRUE}) Essential Value and its CI.}
}
\description{
Calculates Estimated Marginal Means (EMMs) for Q0 and alpha parameters
from a \code{beezdemand_nlme} model for all combinations of specified factor levels.
Reports parameters on both their estimation scale (log10) and their
natural, back-transformed scale. Optionally includes Essential Value (EV).
}
\examples{
\donttest{
data(ko, package = "beezdemand")
ko$y_ll4 <- ll4(ko$y, lambda = 4)
fit <- fit_demand_mixed(ko, y_var = "y_ll4", x_var = "x",
  id_var = "monkey", factors = "dose", equation_form = "zben")
get_demand_param_emms(fit)
}
}
