% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross-price.R
\name{fit_cp_linear}
\alias{fit_cp_linear}
\alias{fit_cp_linear.default}
\alias{fit_cp_linear.mixed}
\title{Fit a Linear Cross-Price Demand Model}
\usage{
fit_cp_linear(
  data,
  type = c("fixed", "mixed"),
  x_var = "x",
  y_var = "y",
  id_var = "id",
  group_var = "group",
  target_var = "target",
  filter_target = TRUE,
  target_level = "alt",
  formula = NULL,
  log10x = FALSE,
  group_effects = FALSE,
  random_slope = FALSE,
  return_all = TRUE,
  ...
)

fit_cp_linear.default(
  data,
  formula = NULL,
  log10x = FALSE,
  return_all = FALSE,
  ...
)

fit_cp_linear.mixed(
  data,
  formula = NULL,
  log10x = FALSE,
  return_all = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame containing columns for price, consumption, and
optionally target indicator, subject identifier, and group.}

\item{type}{The type of model: \code{"fixed"} for standard linear or \code{"mixed"} for
mixed effects.}

\item{x_var}{Character string; name of the price column. Default is \code{"x"}.
Renamed to \code{"x"} internally.}

\item{y_var}{Character string; name of the consumption column. Default is
\code{"y"}. Renamed to \code{"y"} internally.}

\item{id_var}{Character string; name of the subject identifier column.
Default is \code{"id"}. Required for mixed models; renamed to \code{"id"} internally.}

\item{group_var}{Character string; name of the group column. Default is
\code{"group"}. Renamed to \code{"group"} internally when present.}

\item{target_var}{Character string; name of the target indicator column.
Default is \code{"target"}. Renamed to \code{"target"} internally when present.}

\item{filter_target}{Logical; if TRUE (default), filters to rows where the
target column equals \code{target_level}.}

\item{target_level}{Character string; value of the target column to retain
when \code{filter_target = TRUE}. Default is \code{"alt"}.}

\item{formula}{Optional formula override. If NULL, a formula will be
constructed based on other parameters. If non-NULL and any \verb{*_var} argument
differs from its default, an error is thrown because the formula references
canonical column names that no longer exist before renaming; rename columns
before calling, or omit the \code{formula} argument.}

\item{log10x}{Logical; if TRUE and formula is NULL, uses \code{log10(x)} instead
of \code{x} in the formula. Default is FALSE.}

\item{group_effects}{Logical or character; if TRUE, includes group as a factor
with interactions. Can also be \code{"intercept"} for group intercepts only or
\code{"interaction"} for full interactions. Default is FALSE.}

\item{random_slope}{Logical; for mixed models, if TRUE, includes random slopes
for x. Default is FALSE.}

\item{return_all}{Logical; if TRUE, returns additional model metadata.}

\item{...}{Additional arguments passed to underlying modeling functions.}
}
\value{
Fitted linear model.
}
\description{
Fit a Linear Cross-Price Demand Model
}
\examples{
\donttest{
data(etm)
## Fixed-effects linear cross-price model
fit_fixed <- fit_cp_linear(etm, type = "fixed", group_effects = TRUE)
summary(fit_fixed)

## Mixed-effects linear cross-price model
fit_mixed <- fit_cp_linear(etm, type = "mixed", group_effects = TRUE)
summary(fit_mixed)
}
}
