% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp-methods.R
\name{extract_coefficients}
\alias{extract_coefficients}
\title{Extract All Coefficient Types from Cross-Price Demand Models}
\usage{
extract_coefficients(object, ...)
}
\arguments{
\item{object}{A cross-price demand model object (cp_model_nls, cp_model_lm, or cp_model_lmer)}

\item{...}{Additional arguments passed to the appropriate coef method}
}
\value{
For cp_model_nls and cp_model_lm, returns the model coefficients.
For cp_model_lmer, returns a list with fixed, random, and combined coefficients.
}
\description{
A convenience function to extract coefficients from any type of cross-price
demand model in a unified format. For mixed effects models, returns a list
with different coefficient types.
}
\examples{
\donttest{
data(etm, package = "beezdemand")
fit <- fit_cp_nls(etm, equation = "exponentiated")
extract_coefficients(fit)
}
}
