% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle-demand.R
\name{.hurdle_prepare_data}
\alias{.hurdle_prepare_data}
\title{Prepare Hurdle Model Data}
\usage{
.hurdle_prepare_data(data, y_var, x_var, id_var)
}
\arguments{
\item{data}{A validated data frame.}

\item{y_var}{Character string, name of consumption variable.}

\item{x_var}{Character string, name of price variable.}

\item{id_var}{Character string, name of subject ID variable.}
}
\value{
A list containing:
\describe{
\item{price}{Numeric vector of prices}
\item{consumption}{Numeric vector of consumption values}
\item{delta}{Integer vector (1 if consumption == 0, else 0)}
\item{logQ}{Log consumption (0 for zeros)}
\item{subject_id}{0-indexed subject IDs for C++}
\item{subject_levels}{Unique subject IDs (original)}
\item{n_subjects}{Number of unique subjects}
}
}
\description{
Internal function to prepare data structures for TMB hurdle model fitting.
Converts subject IDs to 0-indexed integers and creates derived variables.
}
\keyword{internal}
