% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha-star.R
\name{.calc_alpha_star}
\alias{.calc_alpha_star}
\title{Compute Normalized Alpha (Alpha Star) via the Delta Method}
\usage{
.calc_alpha_star(params, param_scales, vcov = NULL, base = c("e", "10"))
}
\arguments{
\item{params}{Named list of parameter values. Must contain entries matchable
to alpha and k (e.g., \code{alpha}, \code{log_alpha}, \code{log10_alpha}).}

\item{param_scales}{Named list indicating the scale of each parameter in
\code{params}: \code{"natural"}, \code{"log"}, or \code{"log10"}.}

\item{vcov}{Optional. Either a variance--covariance matrix with named
rows/columns, or a named numeric vector of standard errors for the
alpha and k parameters.}

\item{base}{Character; the logarithmic base: \code{"e"} (natural log, used
by hurdle models) or \code{"10"} (log10, used by HS/Koff equations).}
}
\value{
A list with elements:
\describe{
\item{estimate}{Numeric scalar; the alpha_star value, or \code{NA}.}
\item{se}{Numeric scalar; delta-method SE, or \code{NA}.}
\item{note}{Character or \code{NULL}; diagnostic message if alpha_star
could not be computed.}
}
}
\description{
Implements Strategy B normalization of the demand elasticity parameter
\eqn{\alpha} so that values are comparable across different \eqn{k} values
(Rzeszutek et al., 2025). The formula is
\eqn{\alpha^* = -\alpha / \ln(1 - 1/(k \cdot \ln(b)))}{alpha* = -alpha /
ln(1 - 1/(k*ln(b)))} where \eqn{b} is the logarithmic base used by the
demand equation (10 for HS/Koff, \eqn{e} for hurdle models).
}
\details{
Standard errors are obtained via the delta method when a variance--covariance
matrix (or SE vector) is supplied.
}
\references{
Rzeszutek, M. J., Regnier, S. D., Franck, C. T., & Koffarnus, M. N. (2025).
Overviewing the exponential model of demand and introducing a simplification
that solves issues of span, scale, and zeros. \emph{Experimental and Clinical
Psychopharmacology}.
}
\keyword{internal}
