% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp-methods.R
\name{cp_posthoc_intercepts}
\alias{cp_posthoc_intercepts}
\title{Run pairwise intercept comparisons for cross-price demand model}
\usage{
cp_posthoc_intercepts(object, alpha = 0.05, adjust = "tukey", ...)
}
\arguments{
\item{object}{A cp_model_lmer object from fit_cp_linear}

\item{alpha}{Significance level for testing (default: 0.05)}

\item{adjust}{Method for p-value adjustment; see emmeans::contrast (default: "tukey")}

\item{...}{Additional arguments passed to emmeans}
}
\value{
List containing the emmeans table and optionally pairwise comparisons if interaction is significant
}
\description{
This function performs pairwise comparisons of intercepts between groups in a
cross-price demand model, but only when a significant interaction is present.
The emmeans table showing estimated marginal means for intercepts is always returned.
}
\examples{
\donttest{
data(etm)
fit <- fit_cp_linear(etm, type = "mixed", group_effects = TRUE)
cp_posthoc_intercepts(fit)
}
}
