% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp-methods.R
\name{confint.cp_model_nls}
\alias{confint.cp_model_nls}
\title{Confidence Intervals for Cross-Price NLS Model Parameters}
\usage{
\method{confint}{cp_model_nls}(
  object,
  parm = NULL,
  level = 0.95,
  method = c("asymptotic", "profile"),
  ...
)
}
\arguments{
\item{object}{A \code{cp_model_nls} object from \code{\link[=fit_cp_nls]{fit_cp_nls()}}.}

\item{parm}{Character vector of parameter names to compute CIs for.
Default includes all parameters.}

\item{level}{Confidence level (default 0.95).}

\item{method}{Character. Method for computing intervals passed to
\code{nlstools::confint2()}:
\itemize{
\item \code{"asymptotic"} (default): Wald-type asymptotic intervals
\item \code{"profile"}: Profile-t confidence intervals
}}

\item{...}{Additional arguments passed to \code{nlstools::confint2()}.}
}
\value{
A tibble with columns: \code{term}, \code{estimate}, \code{conf.low}, \code{conf.high},
\code{level}, \code{method}.
}
\description{
Computes confidence intervals for parameters from a nonlinear cross-price
demand model using \code{nlstools::confint2()}.
}
\details{
This method wraps \code{nlstools::confint2()} to provide confidence intervals
for the log10-parameterized coefficients (\code{log10_qalone}, \code{I}, \code{log10_beta}).

For back-transformed natural-scale confidence intervals, apply the
transformation: \code{10^conf.low} and \code{10^conf.high} for log10-scale parameters.
}
\examples{
\donttest{
data(etm)
fit <- fit_cp_nls(etm, equation = "exponentiated")
confint(fit)
}

}
