% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed-methods.R
\name{confint.beezdemand_nlme}
\alias{confint.beezdemand_nlme}
\title{Confidence Intervals for Mixed-Effects Demand Model Parameters}
\usage{
\method{confint}{beezdemand_nlme}(object, parm = NULL, level = 0.95, method = c("wald", "profile"), ...)
}
\arguments{
\item{object}{A \code{beezdemand_nlme} object from \code{\link[=fit_demand_mixed]{fit_demand_mixed()}}.}

\item{parm}{Character vector of parameter names to compute CIs for.
Default includes all fixed effect parameters.}

\item{level}{Confidence level (default 0.95).}

\item{method}{Character. Method for computing intervals:
\itemize{
\item \code{"wald"}: Wald-type intervals using asymptotic normality (default, fast)
\item \code{"profile"}: Profile likelihood intervals via \code{nlme::intervals()} (slower
but more accurate for small samples)
}}

\item{...}{Additional arguments passed to \code{nlme::intervals()} when
\code{method = "profile"}.}
}
\value{
A tibble with columns: \code{term}, \code{estimate}, \code{conf.low}, \code{conf.high},
\code{level}, \code{component}.
}
\description{
Computes confidence intervals for fixed effect parameters from an NLME-based
mixed-effects demand model.
}
\details{
For Wald intervals, confidence bounds are computed as estimate ± z * SE
using standard errors from the model summary.

For profile intervals, \code{nlme::intervals()} is called on the underlying
nlme model object. This method provides more accurate intervals but can be
computationally intensive for complex models.
}
\examples{
\donttest{
data(ko)
fit <- fit_demand_mixed(ko, y_var = "y_ll4", x_var = "x",
                        id_var = "monkey", equation_form = "zben")
confint(fit)
}

}
