% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle-methods.R
\name{confint.beezdemand_hurdle}
\alias{confint.beezdemand_hurdle}
\title{Confidence Intervals for Hurdle Demand Model Parameters}
\usage{
\method{confint}{beezdemand_hurdle}(
  object,
  parm = NULL,
  level = 0.95,
  report_space = c("internal", "natural"),
  ...
)
}
\arguments{
\item{object}{A \code{beezdemand_hurdle} object from \code{\link[=fit_demand_hurdle]{fit_demand_hurdle()}}.}

\item{parm}{Character vector of parameter names to compute CIs for.
Default includes all fixed effect parameters.}

\item{level}{Confidence level (default 0.95).}

\item{report_space}{Character. Reporting space for parameters:
\itemize{
\item \code{"internal"}: parameters on internal/fitting scale (log for Q0, alpha)
\item \code{"natural"}: back-transformed to natural scale
}}

\item{...}{Additional arguments (ignored).}
}
\value{
A tibble with columns: \code{term}, \code{estimate}, \code{conf.low}, \code{conf.high},
\code{level}, \code{component}, \code{estimate_scale}.
}
\description{
Computes confidence intervals for fixed effect parameters from a TMB-based
hurdle demand model using the asymptotic normal approximation.
}
\details{
Confidence intervals are computed using the asymptotic normal approximation
based on standard errors from \code{TMB::sdreport()}. For parameters estimated
on the log scale (Q0, alpha, k), intervals can be back-transformed to the
natural scale using \code{report_space = "natural"}.

The transformation uses:
\itemize{
\item For log-scale parameters: exp(estimate +/- z * SE)
}
}
\examples{
\donttest{
data(apt)
fit <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id")
confint(fit)
}

}
