% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed-methods.R
\name{confint.beezdemand_fixed}
\alias{confint.beezdemand_fixed}
\title{Confidence Intervals for Fixed-Effect Demand Model Parameters}
\usage{
\method{confint}{beezdemand_fixed}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{A \code{beezdemand_fixed} object from \code{\link[=fit_demand_fixed]{fit_demand_fixed()}}.}

\item{parm}{Character vector of parameter names to compute CIs for.
Default includes all available parameters.}

\item{level}{Confidence level (default 0.95).}

\item{...}{Additional arguments (ignored).}
}
\value{
A tibble with columns: \code{id}, \code{term}, \code{estimate}, \code{conf.low},
\code{conf.high}, \code{level}.
}
\description{
Computes confidence intervals for Q0, alpha, and k parameters from
individual demand curve fits. Uses asymptotic normal approximation based
on standard errors when available.
}
\details{
For \code{beezdemand_fixed} objects, confidence intervals are computed using
the asymptotic normal approximation: estimate +/- z * SE. If standard errors
are not available for a parameter, the confidence bounds will be \code{NA}.

When the underlying NLS fit objects are available (from \code{detailed = TRUE}),
this method attempts to use \code{nlstools::confint2()} for more accurate
profile-based intervals.
}
\examples{
\donttest{
fit <- fit_demand_fixed(apt, equation = "hs", k = 2)
confint(fit)
confint(fit, level = 0.90)
confint(fit, parm = "Q0")
}

}
