% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-comparison.R
\name{compare_models}
\alias{compare_models}
\title{Compare Demand Models}
\usage{
compare_models(..., test = c("auto", "lrt", "none"))
}
\arguments{
\item{...}{Two or more model objects of class \code{beezdemand_hurdle},
\code{beezdemand_nlme}, or \code{beezdemand_fixed}.}

\item{test}{Character; type of statistical test. One of:
\itemize{
\item \code{"auto"} (default): Use LRT if models are nested and comparable, otherwise IC-only.
\item \code{"lrt"}: Force likelihood ratio test (requires nested models from same backend).
\item \code{"none"}: Only report information criteria, no p-value.
}}
}
\value{
An object of class \code{beezdemand_model_comparison} containing:
\describe{
\item{comparison}{Data frame with model fit statistics}
\item{test_type}{Type of test performed}
\item{lrt_results}{LRT results if performed (NULL otherwise)}
\item{best_model}{Index of best model by BIC}
\item{notes}{Character vector of notes/warnings}
\item{nesting_verified}{Logical; always FALSE since nesting is not
automatically verified. Users must ensure models are properly nested
for valid LRT interpretation.}
}
}
\description{
Compare multiple demand models using information criteria and likelihood
ratio tests (when applicable). Works with all beezdemand model classes.
}
\details{
Models are compared using AIC and BIC. For models from the same statistical
backend (e.g., two hurdle models or two NLME models), likelihood ratio tests
can be performed if the models are nested.

When comparing models from different backends (e.g., hurdle vs NLME), only
information criteria comparisons are possible since the likelihoods are not
directly comparable for LRT purposes.
\subsection{Backend Compatibility}{\tabular{lll}{
   Backend 1 \tab Backend 2 \tab LRT Possible? \cr
   hurdle \tab hurdle \tab Yes (if nested) \cr
   nlme \tab nlme \tab Yes (if nested) \cr
   fixed \tab fixed \tab No (no likelihood) \cr
   hurdle \tab nlme \tab No \cr
   hurdle \tab fixed \tab No \cr
   nlme \tab fixed \tab No \cr
}

}
}
\section{Statistical Notes}{

The likelihood ratio test (LRT) assumes that:
\enumerate{
\item The models are \strong{nested} (the reduced model is a special case of
the full model obtained by constraining parameters).
\item Both models are fit to \strong{identical data}.
\item Under the null hypothesis, the LR statistic follows a chi-square
distribution with degrees of freedom equal to the difference in
the number of parameters.
}

\strong{Important caveat for mixed-effects models:} When variance components
are tested at the boundary (e.g., testing whether a random effect variance
is zero), the standard chi-square distribution is not appropriate. The
correct null distribution is a mixture of chi-squares (Stram & Lee, 1994).
The p-values reported here use the standard chi-square approximation,
which is conservative (p-values are too large) for boundary tests.

This function does \strong{not} automatically verify that models are nested.
Users should ensure models are properly nested before interpreting LRT
p-values.
}

\examples{
\donttest{
data(apt)
fit2 <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id",
                          random_effects = c("zeros", "q0"))
fit3 <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id",
                          random_effects = c("zeros", "q0", "alpha"))
compare_models(fit2, fit3)
}

}
\references{
Stram, D. O., & Lee, J. W. (1994). Variance components testing in the
longitudinal mixed effects model. \emph{Biometrics}, 50(4), 1171-1177.
}
\seealso{
\code{\link[=compare_hurdle_models]{compare_hurdle_models()}} for the legacy hurdle-specific comparison
}
