% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle-utils.R
\name{compare_hurdle_models}
\alias{compare_hurdle_models}
\title{Compare Nested Hurdle Demand Models}
\usage{
compare_hurdle_models(model_full, model_reduced)
}
\arguments{
\item{model_full}{A \code{beezdemand_hurdle} object with 3 random effects.}

\item{model_reduced}{A \code{beezdemand_hurdle} object with 2 random effects.}
}
\value{
Invisibly returns a list with:
\describe{
\item{lr_stat}{Likelihood ratio test statistic}
\item{df}{Degrees of freedom}
\item{p_value}{P-value from chi-squared distribution}
\item{model_comparison}{Data frame with model comparison statistics}
}
}
\description{
Performs a likelihood ratio test comparing two nested hurdle demand models.
Typically used to test whether adding the random effect on alpha (c_i)
significantly improves model fit (3-RE vs 2-RE models).
}
\examples{
\donttest{
data(apt)
fit3 <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id",
                          random_effects = c("zeros", "q0", "alpha"))
fit2 <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id",
                          random_effects = c("zeros", "q0"))
compare_hurdle_models(fit3, fit2)
}

}
\seealso{
\code{\link{fit_demand_hurdle}}
}
