% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{collapse_factor_levels}
\alias{collapse_factor_levels}
\title{Collapse Factor Levels for a Specific Parameter}
\usage{
collapse_factor_levels(data, collapse_spec, factors, suffix)
}
\arguments{
\item{data}{A data frame.}

\item{collapse_spec}{Named list of factor collapse specifications.
Structure: \code{list(factor_name = list(new_level = c(old_levels), ...))}.}

\item{factors}{Character vector of factor names in the model.}

\item{suffix}{Character suffix for new column names (e.g., "Q0" or "alpha").}
}
\value{
A list with:
\itemize{
\item \code{data}: Modified data frame with new collapsed factor columns
\item \code{new_factor_names}: Character vector of new factor column names to use
\item \code{info}: List with original and new levels for each collapsed factor
}
}
\description{
Internal helper to apply level collapsing for a single parameter (Q0 or alpha).
Creates new columns with suffix to avoid modifying original factor columns.
}
\keyword{internal}
