% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed-methods.R
\name{coef.beezdemand_nlme}
\alias{coef.beezdemand_nlme}
\title{Extract Coefficients from a beezdemand_nlme Model}
\usage{
\method{coef}{beezdemand_nlme}(
  object,
  type = "combined",
  report_space = c("internal", "natural", "log10"),
  ...
)
}
\arguments{
\item{object}{A \code{beezdemand_nlme} object.}

\item{type}{Character, type of coefficients to extract. One of:
\itemize{
\item \code{"fixed"}: Returns only fixed effects (equivalent to \code{fixef(object)}).
\item \code{"random"}: Returns only random effects (equivalent to \code{ranef(object)}).
\item \code{"combined"} (default): Returns subject-specific coefficients, where each
subject's coefficient is the sum of the corresponding fixed effect
and that subject's random effect deviation. This is equivalent to
what \code{stats::coef()} on an \code{nlme} object returns.
}}

\item{report_space}{Character. One of \code{"internal"} (default), \code{"natural"}, or \code{"log10"}.}

\item{...}{Additional arguments passed to the underlying \code{nlme} coefficient extraction
functions (\code{nlme::fixef()}, \code{nlme::ranef()}, or \code{stats::coef.nlme()}).}
}
\value{
Depending on \code{type}:
\itemize{
\item \code{type="fixed"}: A named numeric vector of fixed-effect coefficients.
\item \code{type="random"}: A data frame (or list of data frames if multiple levels of grouping)
of random effects, as returned by \code{ranef.nlme()}.
\item \code{type="combined"}: A data frame where rows are subjects (from \code{id_var})
and columns are the Q0 and alpha parameters, representing subject-specific
estimates (on the log10 scale).
}
}
\description{
Provides methods to extract fixed effects, random effects, or subject-specific
(combined fixed + random) coefficients from a \code{beezdemand_nlme} object.
This is an S3 method for the generic \code{coef} function.
}
\examples{
\donttest{
data(ko)
fit <- fit_demand_mixed(ko, y_var = "y_ll4", x_var = "x",
                        id_var = "monkey", equation_form = "zben")
coef(fit, type = "fixed")
coef(fit, type = "random")
coef(fit, type = "combined")
}
}
\seealso{
\code{\link{fixef.beezdemand_nlme}}, \code{\link{ranef.beezdemand_nlme}}
}
