% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp-methods.R
\name{coef-methods}
\alias{coef-methods}
\alias{coef.cp_model_nls}
\alias{coef.cp_model_lm}
\alias{coef.cp_model_lmer}
\title{Extract Coefficients from Cross-Price Demand Models}
\usage{
\method{coef}{cp_model_nls}(object, ...)

\method{coef}{cp_model_lm}(object, ...)

\method{coef}{cp_model_lmer}(object, fixed_only = FALSE, combine = TRUE, ...)
}
\arguments{
\item{object}{A cp_model_lm object}

\item{...}{Additional arguments (not used).}

\item{fixed_only}{Logical; if TRUE, returns only fixed effects. Default is FALSE.}

\item{combine}{Logical; if TRUE and fixed_only=FALSE, returns fixed + random effects combined. Default is TRUE.}
}
\value{
Named vector of coefficients

A named numeric vector of model coefficients.
}
\description{
Methods to extract coefficients from various cross-price demand model objects.
}
\section{Functions}{
\itemize{
\item \code{coef(cp_model_nls)}: Extract coefficients from a nonlinear cross-price model

\item \code{coef(cp_model_lm)}: Extract coefficients from a linear cross-price model

\item \code{coef(cp_model_lmer)}: Extract coefficients from a mixed-effects cross-price model

}}
