% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/systematic.R
\name{check_unsystematic_cp}
\alias{check_unsystematic_cp}
\title{Check for Unsystematic Patterns in Cross-Price Data}
\usage{
check_unsystematic_cp(
  data,
  delta_threshold = 0.025,
  bounce_down_threshold = 0.1,
  bounce_up_threshold = 0.1,
  bounce_none_threshold = 0.1,
  rev_zeroes = 2,
  ret_nums = 2,
  expected_down = FALSE,
  verbose = FALSE,
  detailed = FALSE
)
}
\arguments{
\item{data}{A data frame with columns 'x' and 'y', where 'x' is price and 'y' is consumption.}

\item{delta_threshold}{Numeric. Threshold for detecting log-scale trends (default 0.025).}

\item{bounce_down_threshold}{Numeric. Minimum downward bounce proportion to count as significant in upward trends.}

\item{bounce_up_threshold}{Numeric. Minimum upward bounce proportion to count as significant in downward trends.}

\item{bounce_none_threshold}{Numeric. Minimum bounce proportion to count as significant in no-trend cases.}

\item{rev_zeroes}{Integer. Length of zero sequences to detect reversals (default 2).}

\item{ret_nums}{Integer. Length of non-zero sequences to detect returns (default 2).}

\item{expected_down}{Logical. If TRUE, suppress reversal detection.}

\item{verbose}{Logical. If TRUE, print intermediate values (default FALSE).}

\item{detailed}{Logical. If TRUE, return additional columns including all trend/bounce flags.}
}
\value{
A data frame of class \code{cp_unsystematic} with core results:
\describe{
\item{delta_direction}{Character: 'down', 'up', or 'none'.}
\item{bounce_direction}{Character: 'up', 'down', 'significant', or 'none'.}
\item{bounce_any}{Logical. TRUE if any bounce pattern detected.}
\item{bounce_above}{Integer. Number of upward changes meeting threshold.}
\item{bounce_below}{Integer. Number of downward changes meeting threshold.}
\item{reversals}{Integer. Detected reversals from 0 to non-0.}
\item{returns}{Integer. Detected returns from non-0 to 0.}
}
If \code{detailed = TRUE}, returns additional columns:
\describe{
\item{delta_down}{Logical. Significant downward trend.}
\item{delta_up}{Logical. Significant upward trend.}
\item{delta_none}{Logical. No significant trend.}
\item{bounce_up}{Logical. Significant bounce up in a downward trend.}
\item{bounce_down}{Logical. Significant bounce down in an upward trend.}
\item{bounce_none}{Logical. Significant bounces in no-trend data.}
}
}
\description{
Analyzes whether consumption data shows systematic trends or unsystematic patterns ("bounces")
with respect to price. Includes detection of zero-value reversal/return sequences and allows
flexible output based on the level of detail requested. See Rzeszutek et al. (in press) for
more details.
}
\examples{
x_seq <- 10^(seq(-2, 2, length.out = 10))
pattern <- data.frame(x = x_seq, y = c(10, 5, 10, 9, 10, 13, 10, 10, 7, 9))
check_unsystematic_cp(pattern)

}
