% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{check_demand_model}
\alias{check_demand_model}
\alias{check_demand_model.beezdemand_hurdle}
\alias{check_demand_model.beezdemand_nlme}
\alias{check_demand_model.beezdemand_fixed}
\title{Check Demand Model Diagnostics}
\usage{
check_demand_model(object, ...)

\method{check_demand_model}{beezdemand_hurdle}(object, ...)

\method{check_demand_model}{beezdemand_nlme}(object, ...)

\method{check_demand_model}{beezdemand_fixed}(object, ...)
}
\arguments{
\item{object}{A fitted model object of class \code{beezdemand_hurdle},
\code{beezdemand_nlme}, or \code{beezdemand_fixed}.}

\item{...}{Additional arguments passed to methods.}
}
\value{
An object of class \code{beezdemand_diagnostics} containing:
\describe{
\item{convergence}{List with convergence status and messages}
\item{boundary}{List with boundary condition warnings}
\item{residuals}{Summary statistics for residuals}
\item{random_effects}{Summary of random effects (if applicable)}
\item{issues}{Character vector of identified issues}
\item{recommendations}{Character vector of recommendations}
}
}
\description{
Performs diagnostic checks on fitted demand models, returning information
about convergence, boundary conditions, and residual patterns.
}
\details{
The function checks for:
\itemize{
\item Convergence status and optimization messages
\item Parameters at or near boundaries
\item Residual patterns (heteroscedasticity, outliers)
\item Random effect variance estimates near zero
\item Correlation matrices near singularity
}
}
\note{
This function is named \code{check_demand_model()} to avoid potential conflicts
with \code{performance::check_model()} from the performance package.
}
\examples{
\donttest{
data(apt)
fit <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id")
diagnostics <- check_demand_model(fit)
print(diagnostics)
}

}
\seealso{
\code{\link[=plot_residuals]{plot_residuals()}}, \code{\link[=plot_qq]{plot_qq()}}
}
