% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle-utils.R
\name{calc_omax_pmax}
\alias{calc_omax_pmax}
\title{Calculate Omax and Pmax for Demand Curves}
\usage{
calc_omax_pmax(Q0, k, alpha, price_range = NULL)
}
\arguments{
\item{Q0}{Intensity parameter (consumption at price 0).}

\item{k}{Scaling parameter for the exponential decay.}

\item{alpha}{Elasticity parameter (rate of decay).}

\item{price_range}{Numeric vector of length 2 specifying the price range
to search for Pmax. Default is \code{NULL}, which uses an adaptive range
based on alpha (approximately 0 to 10/alpha).}
}
\value{
A named list with:
\describe{
\item{Pmax}{Price at maximum expenditure}
\item{Omax}{Maximum expenditure (price * quantity)}
\item{Qmax}{Quantity at Pmax}
}
}
\description{
Calculates the maximum expenditure (Omax) and the price at maximum expenditure (Pmax)
for the exponential demand model used in the two-part hurdle model.
}
\details{
For the demand function:
\deqn{Q(p) = Q_0 \cdot \exp(k \cdot (\exp(-\alpha \cdot p) - 1))}

Expenditure is E(p) = p * Q(p). Omax is the maximum of E(p) and Pmax is the
price at which this maximum occurs. These are found numerically.

The search range is automatically adjusted based on alpha to ensure the
maximum is found. For small alpha values, Pmax can be quite large.
}
\examples{
# Calculate for group-level parameters
calc_omax_pmax(Q0 = 10, k = 2, alpha = 0.5)

# With k >= e (~2.718), a local maximum exists
calc_omax_pmax(Q0 = 10, k = 3, alpha = 0.5)

}
\seealso{
\code{\link{calc_group_metrics}}, \code{\link{fit_demand_hurdle}}
}
