% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmax-omax-engine.R
\name{calc_observed_pmax_omax}
\alias{calc_observed_pmax_omax}
\title{Calculate Observed Pmax/Omax Grouped by ID}
\usage{
calc_observed_pmax_omax(
  data,
  id_var = "id",
  price_var = "x",
  consumption_var = "y"
)
}
\arguments{
\item{data}{Data frame with id, price, and consumption columns}

\item{id_var}{Name of ID column}

\item{price_var}{Name of price column}

\item{consumption_var}{Name of consumption column}
}
\value{
Data frame with observed pmax/omax for each subject
}
\description{
Calculate Observed Pmax/Omax Grouped by ID
}
\examples{
\donttest{
data(apt, package = "beezdemand")
calc_observed_pmax_omax(apt, id_var = "id", price_var = "x", consumption_var = "y")
}
}
