% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle-utils.R
\name{calc_group_metrics}
\alias{calc_group_metrics}
\title{Calculate Group-Level Demand Metrics}
\usage{
calc_group_metrics(object)
}
\arguments{
\item{object}{A fitted \code{beezdemand_hurdle} object.}
}
\value{
A named list with group-level Pmax, Omax, and Qmax.
}
\description{
Calculates group-level (population) Omax and Pmax from a fitted hurdle demand model.
}
\examples{
\donttest{
data(apt)
fit <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id")
calc_group_metrics(fit)
}

}
\seealso{
\code{\link{calc_omax_pmax}}, \code{\link{fit_demand_hurdle}}
}
