% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical-methods.R
\name{beezdemand_empirical_methods}
\alias{beezdemand_empirical_methods}
\alias{print.beezdemand_empirical}
\alias{summary.beezdemand_empirical}
\alias{plot.beezdemand_empirical}
\title{S3 Methods for beezdemand_empirical Objects}
\usage{
\method{print}{beezdemand_empirical}(x, ...)

\method{summary}{beezdemand_empirical}(object, ...)

\method{plot}{beezdemand_empirical}(x, type = "histogram", ...)
}
\arguments{
\item{x, object}{A \code{beezdemand_empirical} object}

\item{...}{Additional arguments passed to plotting functions}

\item{type}{Character string specifying plot type. Options:
\itemize{
\item "histogram" (default) - Faceted histograms showing distribution of each measure
\item "matrix" - Scatterplot matrix showing pairwise relationships between measures
}}
}
\value{
\itemize{
\item \code{print()} - Returns the object invisibly (called for side effects)
\item \code{summary()} - Returns a list with extended summary information
\item \code{plot()} - Returns a ggplot2 object
}
}
\description{
Methods for printing, summarizing, and visualizing objects of class
\code{beezdemand_empirical} created by \code{\link[=get_empirical_measures]{get_empirical_measures()}}.
}
\details{
\subsection{Print Method}{

Displays a compact summary showing the number of subjects analyzed and a
preview of the empirical measures table.
}

\subsection{Summary Method}{

Provides extended information including:
\itemize{
\item Data summary (subjects, zero consumption patterns, completeness)
\item Descriptive statistics for each empirical measure (min, median, mean, max, SD)
\item Missing data patterns
}
}

\subsection{Plot Method}{

Creates visualizations of empirical measures across subjects.

\strong{Histogram type} (default):
\itemize{
\item Six-panel faceted plot showing distribution of each measure
\item Helps identify central tendencies and outliers
\item Uses modern beezdemand styling
}

\strong{Matrix type}:
\itemize{
\item Scatterplot matrix (pairs plot) showing relationships between measures
\item Useful for identifying correlated demand metrics
\item Lower triangle: scatterplots with smoothed trend lines
\item Diagonal: density plots
\item Upper triangle: correlation coefficients
}
}
}
\examples{
\donttest{
data(apt, package = "beezdemand")
emp <- get_empirical_measures(apt)

# Print compact summary
print(emp)

# Extended summary
summary(emp)

# Histogram of measure distributions
plot(emp)

# Scatterplot matrix
plot(emp, type = "matrix")
}

}
\seealso{
\code{\link[=get_empirical_measures]{get_empirical_measures()}}
}
