% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive-methods.R
\name{beezdemand_descriptive_methods}
\alias{beezdemand_descriptive_methods}
\alias{print.beezdemand_descriptive}
\alias{summary.beezdemand_descriptive}
\alias{plot.beezdemand_descriptive}
\title{S3 Methods for beezdemand_descriptive Objects}
\usage{
\method{print}{beezdemand_descriptive}(x, ...)

\method{summary}{beezdemand_descriptive}(object, ...)

\method{plot}{beezdemand_descriptive}(x, x_trans = "identity", y_trans = "identity", show_zeros = FALSE, ...)
}
\arguments{
\item{x, object}{A \code{beezdemand_descriptive} object}

\item{...}{Additional arguments (currently unused)}

\item{x_trans}{Character string specifying x-axis transformation. Options:
"identity" (default), "log10", "log", "sqrt". See \code{\link[scales:transform_log]{scales::transform_log10()}} etc.}

\item{y_trans}{Character string specifying y-axis transformation. Options:
"identity" (default), "log10", "log", "sqrt", "pseudo_log" (signed log).}

\item{show_zeros}{Logical indicating whether to show proportion of zeros as labels
on the boxplot (default: FALSE)}
}
\value{
\itemize{
\item \code{print()} - Returns the object invisibly (called for side effects)
\item \code{summary()} - Returns a list with extended summary information
\item \code{plot()} - Returns a ggplot2 object
}
}
\description{
Methods for printing, summarizing, and visualizing objects of class
\code{beezdemand_descriptive} created by \code{\link[=get_descriptive_summary]{get_descriptive_summary()}}.
}
\details{
\subsection{Print Method}{

Displays a compact summary showing the number of subjects and prices analyzed,
plus a preview of the statistics table.
}

\subsection{Summary Method}{

Provides extended information including:
\itemize{
\item Data summary (subjects, prices analyzed)
\item Distribution of means across prices (min, median, max)
\item Proportion of zeros by price (range)
\item Missing data summary
}
}

\subsection{Plot Method}{

Creates a boxplot showing the distribution of consumption at each price point.
Features:
\itemize{
\item Red cross markers indicate means
\item Boxes show median and quartiles
\item Whiskers extend to 1.5 * IQR
\item Supports axis transformations (log, sqrt, etc.)
\item Uses modern beezdemand styling via \code{\link[=theme_apa]{theme_apa()}}
}
}
}
\examples{
\donttest{
data(apt, package = "beezdemand")
desc <- get_descriptive_summary(apt)

# Print compact summary
print(desc)

# Extended summary
summary(desc)

# Default boxplot
plot(desc)

# With log-transformed y-axis
plot(desc, y_trans = "log10")

# With pseudo-log y-axis (handles zeros gracefully)
plot(desc, y_trans = "pseudo_log")
}

}
\seealso{
\code{\link[=get_descriptive_summary]{get_descriptive_summary()}}
}
