% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmax-omax-engine.R
\name{beezdemand_calc_pmax_omax_vec}
\alias{beezdemand_calc_pmax_omax_vec}
\title{Calculate Pmax/Omax for Multiple Subjects}
\usage{
beezdemand_calc_pmax_omax_vec(
  params_df,
  model_type,
  param_scales = NULL,
  price_list = NULL,
  consumption_list = NULL,
  ...
)
}
\arguments{
\item{params_df}{Data frame with one row per subject, containing parameter columns}

\item{model_type}{Character: model type (same for all subjects)}

\item{param_scales}{Named list of parameter scales}

\item{price_list}{Optional list of price vectors (one per subject)}

\item{consumption_list}{Optional list of consumption vectors (one per subject)}

\item{...}{Additional arguments passed to beezdemand_calc_pmax_omax}
}
\value{
Data frame with pmax/omax results for each subject
}
\description{
Calculate Pmax/Omax for Multiple Subjects
}
\examples{
\donttest{
params_df <- data.frame(
  alpha = c(0.001, 0.002),
  q0 = c(10, 15),
  k = c(3, 3)
)
beezdemand_calc_pmax_omax_vec(params_df, model_type = "hs")
}
}
\keyword{internal}
