% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmax-omax-engine.R
\name{beezdemand_calc_pmax_omax}
\alias{beezdemand_calc_pmax_omax}
\title{Calculate Pmax and Omax with Method Reporting and Parameter-Space Safety}
\usage{
beezdemand_calc_pmax_omax(
  model_type = NULL,
  params = NULL,
  param_scales = NULL,
  expenditure_fn = NULL,
  demand_fn = NULL,
  price_obs = NULL,
  consumption_obs = NULL,
  tol = 0.1,
  compute_observed = NULL
)
}
\arguments{
\item{model_type}{Character: "hs", "koff", "hurdle", "hurdle_hs_stdq0", "snd", "simplified", or NULL}

\item{params}{Named list of parameters. Names depend on model_type:
\itemize{
\item hs/koff: alpha, q0, k
\item hurdle: alpha, q0, k (note: hurdle uses different formula)
\item hurdle_hs_stdq0: alpha, q0, k (Q0 appears inside exponent)
\item snd/simplified: alpha, q0
}}

\item{param_scales}{Named list mapping parameter names to their input scales:
"natural", "log", or "log10". Default assumes all natural.}

\item{expenditure_fn}{Optional function E(p) for numerical fallback. If NULL
and model_type is provided, will be constructed from params.}

\item{demand_fn}{Optional function Q(p) for elasticity calculation.}

\item{price_obs}{Numeric vector of observed prices (required for observed
metrics and domain constraints).}

\item{consumption_obs}{Numeric vector of observed consumption (for observed metrics).}

\item{tol}{Tolerance for unit elasticity check (default 0.1).}

\item{compute_observed}{Logical; compute observed metrics? Default TRUE if
price_obs and consumption_obs are provided.}
}
\value{
A list with snake_case fields:
\describe{
\item{pmax_model}{Model-based pmax}
\item{omax_model}{Model-based omax}
\item{q_at_pmax_model}{Quantity at pmax}
\item{method_model}{Method used: "analytic_lambert_w", "analytic_snd", "numerical_optimize_observed_domain"}
\item{domain_model}{Price domain used for computation}
\item{is_boundary_model}{Logical; is pmax at domain boundary?}
\item{elasticity_at_pmax_model}{Elasticity evaluated at pmax}
\item{unit_elasticity_pass_model}{Logical; is elasticity near -1?}
\item{note_model}{Any notes about model computation}
\item{pmax_obs}{Observed pmax}
\item{omax_obs}{Observed omax}
\item{method_obs}{Method for observed: "row_wise_max"}
\item{tie_break_obs}{Tie-break rule: "min_price"}
\item{n_obs_rows}{Number of observation rows}
\item{n_unique_prices}{Number of unique prices}
\item{has_duplicate_prices}{Logical; duplicate prices detected?}
\item{n_max_ties}{Number of rows achieving omax}
\item{note_obs}{Notes about observed computation}
\item{alpha_scale_in}{Input scale for alpha}
\item{q0_scale_in}{Input scale for Q0}
\item{k_scale_in}{Input scale for k (if applicable)}
\item{note_param_space}{Notes about parameter conversions}
}
}
\description{
Unified internal engine for pmax/omax computation. Supports analytic solutions
(Lambert W for HS/hurdle, closed-form for SND), numerical fallback, and
observed (row-wise) metrics. Handles parameter-space conversions transparently.
}
\examples{
\donttest{
result <- beezdemand_calc_pmax_omax(
  model_type = "hs",
  params = list(alpha = 0.001, q0 = 10, k = 3),
  price_obs = c(0, 0.5, 1, 2, 4, 8, 16),
  consumption_obs = c(10, 9, 8, 6, 3, 1, 0)
)
result$pmax_model
result$omax_model
}
}
\keyword{internal}
